/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.reflect;

import com.andavin.reflect.AttributeMatcher;
import com.andavin.reflect.Reflection;
import com.andavin.reflect.exception.UncheckedNoSuchMethodException;
import com.andavin.reflect.exception.UncheckedReflectiveOperationException;
import com.andavin.util.Logger;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Collectors;

public class MethodMatcher
extends AttributeMatcher<Method, MethodMatcher> {
    private static final int BRIDGE = 64;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class<?>[] parametersTypes;

    public MethodMatcher() {
        this(null, EMPTY_CLASS_ARRAY);
    }

    public MethodMatcher(Class<?> returnType) {
        this(returnType, EMPTY_CLASS_ARRAY);
    }

    public MethodMatcher(Class<?> returnType, Class<?> ... parametersTypes) {
        super(returnType, Modifier.methodModifiers() | 0x40);
        this.parametersTypes = parametersTypes;
    }

    public MethodMatcher requireBridge() {
        this.requiredModifiers |= 0x40;
        if ((this.disallowedModifiers & 0x40) != 0) {
            Logger.warn("Bridge is both required and disallowed.");
        }
        return this;
    }

    public MethodMatcher disallowBridge() {
        this.disallowedModifiers |= 0x40;
        if ((this.requiredModifiers & 0x40) != 0) {
            Logger.warn("Bridge is both required and disallowed.");
        }
        return this;
    }

    @Override
    public MethodMatcher requireExactMatch() {
        this.requireExactMatch = true;
        return this;
    }

    @Override
    public boolean match(Method method) {
        return this.match(method.getModifiers(), method.getReturnType()) && (this.parametersTypes == null || Reflection.compare(method.getParameterTypes(), this.parametersTypes, this.requireExactMatch));
    }

    @Override
    UncheckedReflectiveOperationException buildException() {
        return new UncheckedNoSuchMethodException("Could not find method " + (this.mainType != null ? this.mainType.getSimpleName() : "anyType") + " anyMethod(" + (this.parametersTypes != null ? Arrays.stream(this.parametersTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) : "any parameters") + ") requiring " + Integer.toBinaryString(this.requiredModifiers) + " and disallowing " + Integer.toBinaryString(this.disallowedModifiers));
    }
}

